/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.betterx.bclib.api.v2.levelgen.features.config.ScatterFeatureConfig;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betternether.blocks.BlockStalactite;

public class ScatterFeatureConfigs {

    public static class WithSizeOnBase
    extends WithSize {
        public static final Codec<WithSizeOnBase> CODEC = WithSizeOnBase.buildCodec(WithSizeOnBase::new);

        public WithSizeOnBase(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        public static ScatterFeatureConfig.Builder<WithSizeOnBase> startWithSizeOnBase() {
            return ScatterFeatureConfig.Builder.start(WithSizeOnBase::new);
        }

        @Override
        public boolean isValidBase(BlockState state) {
            return this.baseState.isPresent() && state.m_60713_(((BlockState)this.baseState.get()).m_60734_());
        }
    }

    public static class WithSize
    extends ScatterFeatureConfig.OnSolid {
        public static final Codec<WithSize> CODEC = WithSize.buildCodec(WithSize::new);

        public WithSize(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        public static ScatterFeatureConfig.Builder<WithSize> startWithSize() {
            return ScatterFeatureConfig.Builder.start(WithSize::new);
        }

        public boolean isValidBase(BlockState state) {
            if (this.baseState.isPresent() && state.m_60713_(((BlockState)this.baseState.get()).m_60734_())) {
                return true;
            }
            return BlocksHelper.isTerrain((BlockState)state);
        }

        public BlockState createBlock(int height, int maxHeight, RandomSource random, BlockPos pos) {
            return (BlockState)super.createBlock(height, maxHeight, random, pos).m_61124_((Property)BlockStalactite.SIZE, (Comparable)Integer.valueOf(Math.max(0, Math.min(7, maxHeight - height))));
        }
    }

    public static class WithPlantAge
    extends ScatterFeatureConfig.OnSolid {
        public static final Codec<WithPlantAge> CODEC = WithPlantAge.buildCodec(WithPlantAge::new);

        public WithPlantAge(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        public static ScatterFeatureConfig.Builder<WithPlantAge> startWithPlantAge() {
            return ScatterFeatureConfig.Builder.start(WithPlantAge::new);
        }

        public boolean isValidBase(BlockState state) {
            if (this.baseState.isPresent() && state.m_60713_(((BlockState)this.baseState.get()).m_60734_())) {
                return true;
            }
            return BlocksHelper.isTerrain((BlockState)state);
        }

        public BlockState createBlock(int height, int maxHeight, RandomSource random, BlockPos pos) {
            return (BlockState)super.createBlock(height, maxHeight, random, pos).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(random.m_188503_(4)));
        }
    }
}

